"use strict";
exports.id = 1989;
exports.ids = [1989];
exports.modules = {

/***/ 69819:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({"src":"/_next/static/media/locationSelect.8fc3b3e4.png","height":70,"width":70,"blurDataURL":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAgAAAAICAYAAADED76LAAAA3klEQVR42kXOu4rCQBgF4HnD3c5yQbRYsFDWJJthDYm7KRfRysLKUsR4BxH1JcRGrCwUycyouYjzG3+10Bw43QfnkEdSn8VEyxlhJmNFuawZtdtDTKe/3sgzGi3Znh+gvKKEe49HDxXFMmJQKJuC7xEWc7islsDFHvN5U3+B77+qJbY79Os1CFsN4Iyjov3SF9C1f4v7Ia6bDdjMpsDvc2r2Jwa0UDFdJlB4HhyCABjjqKpFPQZGxRbigOezlKfwJF2XIaV2fPIjZSSczhh7/UnU6Y4ixxlgMpl7J4SQG8+ajnmk6x2gAAAAAElFTkSuQmCC","blurWidth":8,"blurHeight":8});

/***/ }),

/***/ 96117:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "p": () => (/* binding */ StyledRating)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(65692);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _mui_system__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(97986);
/* harmony import */ var _mui_system__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_mui_system__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _typographies_Body2__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(15220);
/* harmony import */ var _mui_icons_material_Star__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(77849);
/* harmony import */ var _mui_icons_material_Star__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_mui_icons_material_Star__WEBPACK_IMPORTED_MODULE_5__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_typographies_Body2__WEBPACK_IMPORTED_MODULE_4__]);
_typographies_Body2__WEBPACK_IMPORTED_MODULE_4__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];






const StyledRating = (0,_mui_material__WEBPACK_IMPORTED_MODULE_2__.styled)(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Rating)(({ theme , primary_color , hasRating  })=>({
        "& .MuiRating-iconFilled": {
            color: primary_color === "true" ? theme.palette.primary.main : hasRating && (0,_mui_material__WEBPACK_IMPORTED_MODULE_2__.alpha)(theme.palette.whiteContainer.main, 0.6)
        }
    }));
const CustomMultipleRatings = (props)=>{
    const { rating , PrimaryColor , withCount  } = props;
    const handleRating = (rating)=>{
        return `(${rating})`;
    };
    return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        children: withCount ? /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_mui_system__WEBPACK_IMPORTED_MODULE_3__.Stack, {
            direction: "row",
            alignItems: "center",
            justifyContent: "center",
            spacing: 0.4,
            children: [
                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(StyledRating, {
                    primary_color: PrimaryColor ? "true" : "false",
                    name: "read-only",
                    value: rating,
                    readOnly: true,
                    sx: {
                        fontSize: {
                            xs: "18px",
                            md: "22px"
                        }
                    },
                    emptyIcon: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx((_mui_icons_material_Star__WEBPACK_IMPORTED_MODULE_5___default()), {
                        style: {
                            opacity: 0.55
                        },
                        fontSize: "inherit"
                    })
                }),
                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_typographies_Body2__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
                    text: handleRating(rating)
                })
            ]
        }) : /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(StyledRating, {
            primary_color: PrimaryColor ? "true" : "false",
            name: "read-only",
            value: rating,
            readOnly: true,
            sx: {
                fontSize: {
                    xs: "18px",
                    md: "17px"
                }
            },
            emptyIcon: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx((_mui_icons_material_Star__WEBPACK_IMPORTED_MODULE_5___default()), {
                style: {
                    opacity: 0.55
                },
                fontSize: "inherit"
            })
        })
    });
};
CustomMultipleRatings.propTypes = {};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (CustomMultipleRatings);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 82849:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(45269);
/* harmony import */ var _CustomImageContainer__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(58861);
/* harmony import */ var _public_static_locationSelect_png__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(69819);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(65692);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var i18next__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(22021);
/* harmony import */ var react_geolocated__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(11022);
/* harmony import */ var react_geolocated__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(react_geolocated__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var next_dynamic__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(5152);
/* harmony import */ var next_dynamic__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(next_dynamic__WEBPACK_IMPORTED_MODULE_8__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([i18next__WEBPACK_IMPORTED_MODULE_6__]);
i18next__WEBPACK_IMPORTED_MODULE_6__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];









const MapModal = next_dynamic__WEBPACK_IMPORTED_MODULE_8___default()(()=>Promise.all(/* import() */[__webpack_require__.e(8270), __webpack_require__.e(233)]).then(__webpack_require__.bind(__webpack_require__, 80233)), {
    loadableGenerated: {
        modules: [
            "..\\src\\components\\GetLocationAlert.js -> " + "./Map/MapModal"
        ]
    }
});
const GetLocationAlert = ({ setOpenAlert  })=>{
    const [open, setOpen] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(false);
    const theme = (0,_mui_material__WEBPACK_IMPORTED_MODULE_5__.useTheme)();
    const { coords  } = (0,react_geolocated__WEBPACK_IMPORTED_MODULE_7__.useGeolocated)({
        positionOptions: {
            enableHighAccuracy: false
        },
        userDecisionTimeout: 5000,
        isGeolocationEnabled: true
    });
    const handleOpen = (e)=>{
        e.stopPropagation();
        setOpen(true);
    //setOpenAlert(false);
    };
    return /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_2__/* .CustomStackFullWidth */ .Xw, {
        p: "1rem",
        justifyContent: "center",
        alignItems: "center",
        spacing: 2,
        children: [
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_CustomImageContainer__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
                src: _public_static_locationSelect_png__WEBPACK_IMPORTED_MODULE_4__/* ["default"].src */ .Z.src,
                width: "70px",
                height: "70px"
            }),
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_5__.Typography, {
                variant: "h5",
                color: theme.palette.neutral[1000],
                children: (0,i18next__WEBPACK_IMPORTED_MODULE_6__.t)("Insert delivery location")
            }),
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_5__.Typography, {
                variant: "subtitle2",
                color: theme.palette.neutral[400],
                textAlign: "center",
                children: (0,i18next__WEBPACK_IMPORTED_MODULE_6__.t)("Please add you delivery location so that we can review if the restaurant is available to deliver in your area or not  ")
            }),
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_5__.Button, {
                variant: "outlined",
                onClick: (e)=>handleOpen(e),
                children: (0,i18next__WEBPACK_IMPORTED_MODULE_6__.t)("Pick from Map")
            }),
            open && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(MapModal, {
                open: open,
                handleClose: ()=>setOpen(false),
                coords: coords,
                disableAutoFocus: true,
                fromStore: true
            })
        ]
    });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (GetLocationAlert);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 71989:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "UK": () => (/* binding */ CardWrapper),
/* harmony export */   "ZP": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* unused harmony export CustomCardButton */
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mui_icons_material_Delete__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(83188);
/* harmony import */ var _mui_icons_material_Delete__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_icons_material_Delete__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(65692);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _mui_material_styles__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(18442);
/* harmony import */ var _mui_material_styles__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_mui_material_styles__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _mui_system__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(97986);
/* harmony import */ var _mui_system__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_mui_system__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var helper_functions_CardHelpers__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(89113);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var react_hot_toast__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(86201);
/* harmony import */ var react_i18next__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(57987);
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(6022);
/* harmony import */ var react_redux__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(react_redux__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var redux_slices_cart__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(23614);
/* harmony import */ var styled_components_CustomButtons_style__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(81029);
/* harmony import */ var styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(45269);
/* harmony import */ var styled_components_TextWithEllipsis__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(53556);
/* harmony import */ var _CustomImageContainer__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(58861);
/* harmony import */ var _food_details_foodDetail_modal_FoodDetailModal__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(49957);
/* harmony import */ var _product_details_product_details_section_states__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(29883);
/* harmony import */ var _CustomBadge__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(15979);
/* harmony import */ var _mui_icons_material_Favorite__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(27372);
/* harmony import */ var _mui_icons_material_Favorite__WEBPACK_IMPORTED_MODULE_19___default = /*#__PURE__*/__webpack_require__.n(_mui_icons_material_Favorite__WEBPACK_IMPORTED_MODULE_19__);
/* harmony import */ var api_manage_api_error_response_ErrorResponses__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(67759);
/* harmony import */ var api_manage_hooks_react_query_wish_list_useAddWishList__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(64038);
/* harmony import */ var api_manage_hooks_react_query_wish_list_useWishListDelete__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(94156);
/* harmony import */ var helper_functions_getCartListModuleWise__WEBPACK_IMPORTED_MODULE_46__ = __webpack_require__(58345);
/* harmony import */ var helper_functions_getCurrentModuleType__WEBPACK_IMPORTED_MODULE_45__ = __webpack_require__(90603);
/* harmony import */ var helper_functions_getLanguage__WEBPACK_IMPORTED_MODULE_50__ = __webpack_require__(46573);
/* harmony import */ var helper_functions_getModuleId__WEBPACK_IMPORTED_MODULE_48__ = __webpack_require__(52539);
/* harmony import */ var helper_functions_getToken__WEBPACK_IMPORTED_MODULE_47__ = __webpack_require__(61859);
/* harmony import */ var helper_functions_moduleTypes__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(42604);
/* harmony import */ var utils_toasterMessages__WEBPACK_IMPORTED_MODULE_49__ = __webpack_require__(70557);
/* harmony import */ var _api_manage_hooks_react_query_add_cart_useAddCartItem__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(39527);
/* harmony import */ var _api_manage_hooks_react_query_add_cart_useCartItemUpdate__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(76227);
/* harmony import */ var _api_manage_hooks_react_query_add_cart_useDeleteCartItem__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(28111);
/* harmony import */ var _redux_slices_wishList__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(64134);
/* harmony import */ var _AmountWithDiscountedAmount__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(94191);
/* harmony import */ var _custom_dialog_confirm_CustomDialogConfirm__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(2922);
/* harmony import */ var _CustomMultipleRatings__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(96117);
/* harmony import */ var _GetLocationAlert__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(82849);
/* harmony import */ var _home_stores_with_filter_cards_grid_StoresInfoCard__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(20762);
/* harmony import */ var _linear_progressbar__WEBPACK_IMPORTED_MODULE_33__ = __webpack_require__(12574);
/* harmony import */ var _modal__WEBPACK_IMPORTED_MODULE_34__ = __webpack_require__(86390);
/* harmony import */ var _product_details_product_details_section_CartClearModal__WEBPACK_IMPORTED_MODULE_35__ = __webpack_require__(73380);
/* harmony import */ var _product_details_product_details_section_helperFunction__WEBPACK_IMPORTED_MODULE_36__ = __webpack_require__(63254);
/* harmony import */ var _typographies_Body2__WEBPACK_IMPORTED_MODULE_37__ = __webpack_require__(15220);
/* harmony import */ var _typographies_H3__WEBPACK_IMPORTED_MODULE_38__ = __webpack_require__(40409);
/* harmony import */ var _AddWithIncrementDecrement__WEBPACK_IMPORTED_MODULE_39__ = __webpack_require__(5282);
/* harmony import */ var _Card_style__WEBPACK_IMPORTED_MODULE_40__ = __webpack_require__(21937);
/* harmony import */ var _ModuleModal__WEBPACK_IMPORTED_MODULE_41__ = __webpack_require__(59876);
/* harmony import */ var _ProductsUnavailable__WEBPACK_IMPORTED_MODULE_42__ = __webpack_require__(86838);
/* harmony import */ var _QuickView__WEBPACK_IMPORTED_MODULE_43__ = __webpack_require__(82681);
/* harmony import */ var _SpecialCard__WEBPACK_IMPORTED_MODULE_44__ = __webpack_require__(52014);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([react_hot_toast__WEBPACK_IMPORTED_MODULE_8__, react_i18next__WEBPACK_IMPORTED_MODULE_9__, _food_details_foodDetail_modal_FoodDetailModal__WEBPACK_IMPORTED_MODULE_16__, api_manage_api_error_response_ErrorResponses__WEBPACK_IMPORTED_MODULE_20__, api_manage_hooks_react_query_wish_list_useAddWishList__WEBPACK_IMPORTED_MODULE_21__, api_manage_hooks_react_query_wish_list_useWishListDelete__WEBPACK_IMPORTED_MODULE_22__, _api_manage_hooks_react_query_add_cart_useAddCartItem__WEBPACK_IMPORTED_MODULE_24__, _api_manage_hooks_react_query_add_cart_useCartItemUpdate__WEBPACK_IMPORTED_MODULE_25__, _api_manage_hooks_react_query_add_cart_useDeleteCartItem__WEBPACK_IMPORTED_MODULE_26__, _custom_dialog_confirm_CustomDialogConfirm__WEBPACK_IMPORTED_MODULE_29__, _CustomMultipleRatings__WEBPACK_IMPORTED_MODULE_30__, _GetLocationAlert__WEBPACK_IMPORTED_MODULE_31__, _home_stores_with_filter_cards_grid_StoresInfoCard__WEBPACK_IMPORTED_MODULE_32__, _product_details_product_details_section_CartClearModal__WEBPACK_IMPORTED_MODULE_35__, _product_details_product_details_section_helperFunction__WEBPACK_IMPORTED_MODULE_36__, _typographies_Body2__WEBPACK_IMPORTED_MODULE_37__, _typographies_H3__WEBPACK_IMPORTED_MODULE_38__, _AddWithIncrementDecrement__WEBPACK_IMPORTED_MODULE_39__, _ModuleModal__WEBPACK_IMPORTED_MODULE_41__, _ProductsUnavailable__WEBPACK_IMPORTED_MODULE_42__, _QuickView__WEBPACK_IMPORTED_MODULE_43__, _SpecialCard__WEBPACK_IMPORTED_MODULE_44__]);
([react_hot_toast__WEBPACK_IMPORTED_MODULE_8__, react_i18next__WEBPACK_IMPORTED_MODULE_9__, _food_details_foodDetail_modal_FoodDetailModal__WEBPACK_IMPORTED_MODULE_16__, api_manage_api_error_response_ErrorResponses__WEBPACK_IMPORTED_MODULE_20__, api_manage_hooks_react_query_wish_list_useAddWishList__WEBPACK_IMPORTED_MODULE_21__, api_manage_hooks_react_query_wish_list_useWishListDelete__WEBPACK_IMPORTED_MODULE_22__, _api_manage_hooks_react_query_add_cart_useAddCartItem__WEBPACK_IMPORTED_MODULE_24__, _api_manage_hooks_react_query_add_cart_useCartItemUpdate__WEBPACK_IMPORTED_MODULE_25__, _api_manage_hooks_react_query_add_cart_useDeleteCartItem__WEBPACK_IMPORTED_MODULE_26__, _custom_dialog_confirm_CustomDialogConfirm__WEBPACK_IMPORTED_MODULE_29__, _CustomMultipleRatings__WEBPACK_IMPORTED_MODULE_30__, _GetLocationAlert__WEBPACK_IMPORTED_MODULE_31__, _home_stores_with_filter_cards_grid_StoresInfoCard__WEBPACK_IMPORTED_MODULE_32__, _product_details_product_details_section_CartClearModal__WEBPACK_IMPORTED_MODULE_35__, _product_details_product_details_section_helperFunction__WEBPACK_IMPORTED_MODULE_36__, _typographies_Body2__WEBPACK_IMPORTED_MODULE_37__, _typographies_H3__WEBPACK_IMPORTED_MODULE_38__, _AddWithIncrementDecrement__WEBPACK_IMPORTED_MODULE_39__, _ModuleModal__WEBPACK_IMPORTED_MODULE_41__, _ProductsUnavailable__WEBPACK_IMPORTED_MODULE_42__, _QuickView__WEBPACK_IMPORTED_MODULE_43__, _SpecialCard__WEBPACK_IMPORTED_MODULE_44__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);



















































const CardWrapper = (0,_mui_material_styles__WEBPACK_IMPORTED_MODULE_3__.styled)(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Card)(({ theme , cardheight , horizontalcard , wishlistcard , nomargin , cardType , cardFor , cardWidth , pharmaCommon  })=>({
        cursor: "pointer",
        backgroundColor: theme.palette.background.custom6,
        padding: horizontalcard !== "true" && "10px",
        maxWidth: cardFor === "list-view" ? "100%" : horizontalcard === "true" ? "440px" : "320px",
        width: cardType === "vertical-type" || cardType === "list-view" ? "100%" : horizontalcard === "true" && "440px",
        margin: wishlistcard === "true" ? "0rem" : nomargin === "true" ? "0rem" : cardType === "vertical-type" ? "0rem" : ".7rem",
        borderRadius: "8px",
        height: cardheight ? cardheight : "220px",
        marginBottom: pharmaCommon && "20px !important",
        // boxShadow:
        //   theme.palette.mode !== "dark"
        //     ? "0px 30px 20px 0px rgba(0, 0, 0, 0.10)"
        //     : "0px 30px 20px 0px rgba(88, 110, 125, 0.10)",
        border: (0,helper_functions_getCurrentModuleType__WEBPACK_IMPORTED_MODULE_45__/* .getCurrentModuleType */ .X)() === helper_functions_moduleTypes__WEBPACK_IMPORTED_MODULE_23__/* .ModuleTypes.FOOD */ .J.FOOD && `1px solid ${(0,_mui_material__WEBPACK_IMPORTED_MODULE_2__.alpha)(theme.palette.moduleTheme.food, 0.1)}`,
        "&:hover": {
            boxShadow: theme.palette.mode !== "dark" ? ` 0px 10px 20px 0px ${(0,_mui_material__WEBPACK_IMPORTED_MODULE_2__.alpha)(theme.palette.neutral[1000], 0.1)}` : "0px 10px 20px 0px rgba(88, 110, 125, 0.10)",
            img: {
                transform: "scale(1.05)"
            }
        },
        "&:hover .MuiTypography-subtitle1, &:hover .name": {},
        [theme.breakpoints.down("sm")]: {
            height: horizontalcard !== "true" ? "320px" : cardheight ? "130px" : "150px",
            width: horizontalcard === "true" ? cardFor === "list-view" ? "100%" : cardWidth ? cardWidth : "95%" : "100%",
            margin: wishlistcard === "true" ? "0rem" : nomargin === "true" ? "0rem" : ".4rem"
        },
        [theme.breakpoints.up("sm")]: {
            height: cardheight ? cardheight : "330px"
        },
        [theme.breakpoints.up("md")]: {
            height: cardheight ? cardheight : "350px"
        }
    }));
const CustomCardMedia = (0,_mui_material_styles__WEBPACK_IMPORTED_MODULE_3__.styled)(_mui_material__WEBPACK_IMPORTED_MODULE_2__.CardMedia)(({ theme , horizontalcard , loveItem  })=>({
        position: "relative",
        //overflow: "hidden",
        padding: loveItem === "true" ? "2px" : horizontalcard === "true" ? ".5rem" : "0rem",
        margin: "2px",
        //borderRadius: horizontalcard === "true" ? "0x 10px" : "10px 10px 0 0",
        height: horizontalcard === "true" ? "100%" : "212px",
        width: horizontalcard === "true" && "215px",
        display: "flex",
        alignItems: "center",
        justifyContent: "center",
        overflow: "hidden",
        borderRadius: "5px",
        ".MuiBox-root": {
            overflow: "hidden",
            borderRadius: "5px"
        },
        backgroundColor: horizontalcard === "true" ? theme.palette.neutral[100] : "none",
        [theme.breakpoints.down("sm")]: {
            width: horizontalcard === "true" ? "160px" : "100%",
            height: horizontalcard === "true" ? "135px" : "175px"
        }
    }));
const CustomCardButton = (0,_mui_material_styles__WEBPACK_IMPORTED_MODULE_3__.styled)(styled_components_CustomButtons_style__WEBPACK_IMPORTED_MODULE_12__/* .CustomButtonPrimary */ .TG)(({ theme , disabled  })=>({
        background: disabled ? (0,_mui_material__WEBPACK_IMPORTED_MODULE_2__.alpha)(theme.palette.secondary.light, 0.3) : theme.palette.secondary.light
    }));
const ProductCard = (props)=>{
    const { loveItem , item , cardheight , horizontalcard , changed_bg , wishlistcard , deleteWishlistItem , cardFor , noMargin , cardType , specialCard , cardWidth , sold , stock , pharmaCommon , noRecommended  } = props;
    const [state, dispatch] = (0,react__WEBPACK_IMPORTED_MODULE_7__.useReducer)(_product_details_product_details_section_states__WEBPACK_IMPORTED_MODULE_17__/* .reducer */ .I6, _product_details_product_details_section_states__WEBPACK_IMPORTED_MODULE_17__/* .initialState */ .E3);
    const [openModal, setOpenModal] = react__WEBPACK_IMPORTED_MODULE_7___default().useState(false);
    const [openLocationAlert, setOpenLocationAlert] = (0,react__WEBPACK_IMPORTED_MODULE_7__.useState)(false);
    const { configData  } = (0,react_redux__WEBPACK_IMPORTED_MODULE_10__.useSelector)((state)=>state.configData);
    const imageBaseUrl = configData?.base_urls?.item_image_url;
    const router = (0,next_router__WEBPACK_IMPORTED_MODULE_6__.useRouter)();
    const theme = (0,_mui_material__WEBPACK_IMPORTED_MODULE_2__.useTheme)();
    const isSmall = (0,_mui_material__WEBPACK_IMPORTED_MODULE_2__.useMediaQuery)(theme.breakpoints.down("sm"));
    const reduxDispatch = (0,react_redux__WEBPACK_IMPORTED_MODULE_10__.useDispatch)();
    const { cartList: aliasCartList  } = (0,react_redux__WEBPACK_IMPORTED_MODULE_10__.useSelector)((state)=>state.cart);
    const cartList = (0,helper_functions_getCartListModuleWise__WEBPACK_IMPORTED_MODULE_46__/* .getCartListModuleWise */ .l)(aliasCartList);
    const classes = (0,styled_components_TextWithEllipsis__WEBPACK_IMPORTED_MODULE_14__/* .textWithEllipsis */ .C)();
    const { t  } = (0,react_i18next__WEBPACK_IMPORTED_MODULE_9__.useTranslation)();
    const p_off = t("%");
    const { wishLists  } = (0,react_redux__WEBPACK_IMPORTED_MODULE_10__.useSelector)((state)=>state.wishList);
    const [isWishlisted, setIsWishlisted] = (0,react__WEBPACK_IMPORTED_MODULE_7__.useState)(false);
    const { mutate: addFavoriteMutation  } = (0,api_manage_hooks_react_query_wish_list_useAddWishList__WEBPACK_IMPORTED_MODULE_21__/* .useAddToWishlist */ .x)();
    const { mutate  } = (0,api_manage_hooks_react_query_wish_list_useWishListDelete__WEBPACK_IMPORTED_MODULE_22__/* .useWishListDelete */ .V)();
    const [isProductExist, setIsProductExist] = (0,react__WEBPACK_IMPORTED_MODULE_7__.useState)(false);
    const [count, setCount] = (0,react__WEBPACK_IMPORTED_MODULE_7__.useState)(0);
    const { mutate: addToMutate , isLoading  } = (0,_api_manage_hooks_react_query_add_cart_useAddCartItem__WEBPACK_IMPORTED_MODULE_24__/* ["default"] */ .Z)();
    const { mutate: updateMutate , isLoading: updateLoading  } = (0,_api_manage_hooks_react_query_add_cart_useCartItemUpdate__WEBPACK_IMPORTED_MODULE_25__/* ["default"] */ .Z)();
    const { mutate: cartItemRemoveMutate  } = (0,_api_manage_hooks_react_query_add_cart_useDeleteCartItem__WEBPACK_IMPORTED_MODULE_26__/* ["default"] */ .Z)();
    (0,react__WEBPACK_IMPORTED_MODULE_7__.useEffect)(()=>{
        const isInCart = getItemFromCartlist();
        if (isInCart) {
            setIsProductExist(true);
            setCount(isInCart?.quantity);
        } else {
            setIsProductExist(false);
        }
    }, [
        aliasCartList
    ]);
    const getItemFromCartlist = ()=>{
        const cartList = (0,helper_functions_getCartListModuleWise__WEBPACK_IMPORTED_MODULE_46__/* .getCartListModuleWise */ .l)(aliasCartList);
        return cartList?.find((things)=>things.id === item?.id);
    };
    (0,react__WEBPACK_IMPORTED_MODULE_7__.useEffect)(()=>{
        wishlistItemExistHandler();
    }, [
        wishLists
    ]);
    const wishlistItemExistHandler = ()=>{
        if (wishLists?.item?.find((wishItem)=>wishItem.id === item?.id)) {
            setIsWishlisted(true);
        } else {
            setIsWishlisted(false);
        }
    };
    (0,react__WEBPACK_IMPORTED_MODULE_7__.useEffect)(()=>{}, [
        state.clearCartModal
    ]);
    const handleClearCartModalOpen = ()=>dispatch({
            type: _product_details_product_details_section_states__WEBPACK_IMPORTED_MODULE_17__/* .ACTION.setClearCartModal */ .om.setClearCartModal,
            payload: true
        });
    const handleCloseForClearCart = (value)=>{
        if (value === "add-item") {
            const itemObject = {
                guest_id: (0,helper_functions_getToken__WEBPACK_IMPORTED_MODULE_47__/* .getGuestId */ .P)(),
                model: state.modalData[0]?.available_date_starts ? "ItemCampaign" : "Item",
                add_on_ids: [],
                add_on_qtys: [],
                item_id: state.modalData[0]?.id,
                price: state?.modalData[0]?.price,
                quantity: state?.modalData[0]?.quantity,
                variation: []
            };
            addToMutate(itemObject, {
                onSuccess: handleSuccess,
                onError: api_manage_api_error_response_ErrorResponses__WEBPACK_IMPORTED_MODULE_20__/* .onErrorResponse */ .RJ
            });
        } else {
            dispatch({
                type: _product_details_product_details_section_states__WEBPACK_IMPORTED_MODULE_17__/* .ACTION.setClearCartModal */ .om.setClearCartModal,
                payload: false
            });
        }
    };
    const handleBadge = ()=>{
        if (Number.parseInt(item?.store_discount) === 0) {
            if (Number.parseInt(item?.discount) > 0) {
                if (item?.discount_type === "percent") {
                    return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_CustomBadge__WEBPACK_IMPORTED_MODULE_18__/* ["default"] */ .Z, {
                        top: 10,
                        text: `${item?.discount}${p_off}`
                    });
                } else {
                    return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_CustomBadge__WEBPACK_IMPORTED_MODULE_18__/* ["default"] */ .Z, {
                        top: 10,
                        text: `${(0,helper_functions_CardHelpers__WEBPACK_IMPORTED_MODULE_5__/* .getAmountWithSign */ .B9)(item?.discount, item?.discount % 1 ? true : false)}`
                    });
                }
            }
        } else {
            if (Number.parseInt(item?.store_discount) > 0) {
                return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_CustomBadge__WEBPACK_IMPORTED_MODULE_18__/* ["default"] */ .Z, {
                    top: 10,
                    text: `${item?.store_discount}${p_off}`
                });
            }
        }
    };
    const handleClick = ()=>{
        if (item?.module_type === "ecommerce") {
            router.push({
                pathname: "/product/[id]",
                query: {
                    id: `${item?.slug ? item?.slug : item?.id}`,
                    module_id: `${(0,helper_functions_getModuleId__WEBPACK_IMPORTED_MODULE_48__/* .getModuleId */ .S)()}`
                }
            });
        } else {
            dispatch({
                type: _product_details_product_details_section_states__WEBPACK_IMPORTED_MODULE_17__/* .ACTION.setOpenModal */ .om.setOpenModal,
                payload: true
            });
        }
    };
    (0,react__WEBPACK_IMPORTED_MODULE_7__.useEffect)(()=>{
        if (item) {
            dispatch({
                type: _product_details_product_details_section_states__WEBPACK_IMPORTED_MODULE_17__/* .ACTION.setModalData */ .om.setModalData,
                payload: {
                    ...item,
                    quantity: 1,
                    price: item?.price,
                    totalPrice: item?.price
                }
            });
        }
    }, [
        item
    ]);
    const isInCart = cartList?.find((things)=>things.id === item?.id);
    const handleSuccess = (res)=>{
        if (res) {
            let product = {};
            res?.forEach((item)=>{
                product = {
                    ...item?.item,
                    cartItemId: item?.id,
                    quantity: item?.quantity,
                    totalPrice: item?.price,
                    selectedOption: []
                };
            });
            reduxDispatch((0,redux_slices_cart__WEBPACK_IMPORTED_MODULE_11__/* .setCart */ .RV)(product));
            react_hot_toast__WEBPACK_IMPORTED_MODULE_8__["default"].success(t("Item added to cart"));
            dispatch({
                type: _product_details_product_details_section_states__WEBPACK_IMPORTED_MODULE_17__/* .ACTION.setClearCartModal */ .om.setClearCartModal,
                payload: false
            });
        }
    };
    const addToCartHandler = ()=>{
        if (cartList.length > 0) {
            const isStoreExist = cartList.find((item)=>item?.store_id === state?.modalData[0]?.store_id);
            if (isStoreExist) {
                if (!isInCart) {
                    const itemObject = {
                        guest_id: (0,helper_functions_getToken__WEBPACK_IMPORTED_MODULE_47__/* .getGuestId */ .P)(),
                        model: state.modalData[0]?.available_date_starts ? "ItemCampaign" : "Item",
                        add_on_ids: [],
                        add_on_qtys: [],
                        item_id: state.modalData[0]?.id,
                        price: state?.modalData[0]?.price,
                        quantity: state?.modalData[0]?.quantity,
                        variation: []
                    };
                    addToMutate(itemObject, {
                        onSuccess: handleSuccess,
                        onError: api_manage_api_error_response_ErrorResponses__WEBPACK_IMPORTED_MODULE_20__/* .onErrorResponse */ .RJ
                    });
                }
            } else {
                if (cartList.length !== 0) {
                    handleClearCartModalOpen();
                }
            }
        } else {
            if (!isInCart) {
                const itemObject1 = {
                    guest_id: (0,helper_functions_getToken__WEBPACK_IMPORTED_MODULE_47__/* .getGuestId */ .P)(),
                    model: state.modalData[0]?.available_date_starts ? "ItemCampaign" : "Item",
                    add_on_ids: [],
                    add_on_qtys: [],
                    item_id: state.modalData[0]?.id,
                    price: state?.modalData[0]?.price,
                    quantity: state?.modalData[0]?.quantity,
                    variation: []
                };
                addToMutate(itemObject1, {
                    onSuccess: handleSuccess,
                    onError: api_manage_api_error_response_ErrorResponses__WEBPACK_IMPORTED_MODULE_20__/* .onErrorResponse */ .RJ
                });
            }
        }
    };
    const addToCart = (e)=>{
        if (item?.module_type === "ecommerce") {
            if (item?.variations.length > 0) {
                router.push({
                    pathname: "/product/[id]",
                    query: {
                        id: `${item?.slug ? item?.slug : item?.id}`,
                        module_id: `${(0,helper_functions_getModuleId__WEBPACK_IMPORTED_MODULE_48__/* .getModuleId */ .S)()}`
                    }
                });
            } else {
                e.stopPropagation();
                addToCartHandler();
            }
        } else {
            if (item?.module_type === "food") {
                if (item?.food_variations?.length > 0) {
                    dispatch({
                        type: _product_details_product_details_section_states__WEBPACK_IMPORTED_MODULE_17__/* .ACTION.setOpenModal */ .om.setOpenModal,
                        payload: true
                    });
                } else {
                    e.stopPropagation();
                    addToCartHandler();
                }
            } else if (item?.variations?.length > 0) {
                dispatch({
                    type: _product_details_product_details_section_states__WEBPACK_IMPORTED_MODULE_17__/* .ACTION.setOpenModal */ .om.setOpenModal,
                    payload: true
                });
            } else {
                e.stopPropagation();
                addToCartHandler();
            }
        }
    };
    const quickViewHandleClick = ()=>{};
    const cartUpdateHandleSuccess = (res)=>{
        if (res) {
            res?.forEach((item)=>{
                if (isInCart?.cartItemId === item?.id) {
                    const product = {
                        ...item?.item,
                        cartItemId: item?.id,
                        totalPrice: item?.price,
                        quantity: item?.quantity,
                        food_variations: item?.item?.food_variations,
                        selectedAddons: item?.item?.addons,
                        itemBasePrice: item?.item?.price,
                        selectedOption: item?.variation
                    };
                    reduxDispatch((0,redux_slices_cart__WEBPACK_IMPORTED_MODULE_11__/* .setIncrementToCartItem */ .yG)(product)); // Dispatch the single product
                }
            });
        }
    };
    const cartUpdateHandleSuccessDecrement = (res)=>{
        if (res) {
            res?.forEach((item)=>{
                const product = {
                    ...item?.item,
                    cartItemId: item?.id,
                    totalPrice: item?.price,
                    quantity: item?.quantity,
                    food_variations: item?.item?.food_variations,
                    selectedAddons: item?.item?.addons,
                    itemBasePrice: item?.item?.price,
                    selectedOption: item?.variation
                };
                reduxDispatch((0,redux_slices_cart__WEBPACK_IMPORTED_MODULE_11__/* .setDecrementToCartItem */ .Aw)(product));
            });
        }
    };
    const handleIncrement = ()=>{
        const isExisted = getItemFromCartlist();
        const updateQuantity = isInCart?.quantity + 1;
        const itemObject = (0,_product_details_product_details_section_helperFunction__WEBPACK_IMPORTED_MODULE_36__/* .getItemDataForAddToCart */ .JG)(isInCart, updateQuantity, (0,_product_details_product_details_section_helperFunction__WEBPACK_IMPORTED_MODULE_36__/* .getPriceAfterQuantityChange */ .bb)(isInCart, updateQuantity), (0,helper_functions_getToken__WEBPACK_IMPORTED_MODULE_47__/* .getGuestId */ .P)());
        if (isExisted) {
            if ((0,helper_functions_getCurrentModuleType__WEBPACK_IMPORTED_MODULE_45__/* .getCurrentModuleType */ .X)() === "food") {
                if (item?.maximum_cart_quantity) {
                    if (item?.maximum_cart_quantity <= isExisted?.quantity) {
                        react_hot_toast__WEBPACK_IMPORTED_MODULE_8__["default"].error(t(utils_toasterMessages__WEBPACK_IMPORTED_MODULE_49__/* .out_of_limits */ .$Q));
                    } else {
                        updateMutate(itemObject, {
                            onSuccess: cartUpdateHandleSuccess,
                            onError: api_manage_api_error_response_ErrorResponses__WEBPACK_IMPORTED_MODULE_20__/* .onErrorResponse */ .RJ
                        });
                    }
                } else {
                    updateMutate(itemObject, {
                        onSuccess: cartUpdateHandleSuccess,
                        onError: api_manage_api_error_response_ErrorResponses__WEBPACK_IMPORTED_MODULE_20__/* .onErrorResponse */ .RJ
                    });
                }
            } else {
                if (isExisted?.quantity + 1 <= item?.stock) {
                    if (item?.maximum_cart_quantity) {
                        if (item?.maximum_cart_quantity <= isExisted?.quantity) {
                            react_hot_toast__WEBPACK_IMPORTED_MODULE_8__["default"].error(t(utils_toasterMessages__WEBPACK_IMPORTED_MODULE_49__/* .out_of_limits */ .$Q));
                        } else {
                            updateMutate(itemObject, {
                                onSuccess: cartUpdateHandleSuccess,
                                onError: api_manage_api_error_response_ErrorResponses__WEBPACK_IMPORTED_MODULE_20__/* .onErrorResponse */ .RJ
                            });
                        }
                    } else {
                        updateMutate(itemObject, {
                            onSuccess: cartUpdateHandleSuccess,
                            onError: api_manage_api_error_response_ErrorResponses__WEBPACK_IMPORTED_MODULE_20__/* .onErrorResponse */ .RJ
                        });
                        reduxDispatch((0,redux_slices_cart__WEBPACK_IMPORTED_MODULE_11__/* .setIncrementToCartItem */ .yG)(isInCart));
                    }
                } else {
                    react_hot_toast__WEBPACK_IMPORTED_MODULE_8__["default"].error(t(utils_toasterMessages__WEBPACK_IMPORTED_MODULE_49__/* .out_of_stock */ ._q));
                }
            }
        }
    };
    const handleClose = ()=>{
        dispatch({
            type: _product_details_product_details_section_states__WEBPACK_IMPORTED_MODULE_17__/* .ACTION.setOpenModal */ .om.setOpenModal,
            payload: false
        });
    };
    const handleSuccessRemoveItem = ()=>{
        reduxDispatch((0,redux_slices_cart__WEBPACK_IMPORTED_MODULE_11__/* .setRemoveItemFromCart */ .jh)(isInCart));
        react_hot_toast__WEBPACK_IMPORTED_MODULE_8__["default"].success(t("Removed from cart."));
    };
    const handleDecrement = ()=>{
        const updateQuantity = isInCart?.quantity - 1;
        const isExisted = getItemFromCartlist();
        if (isExisted?.quantity === 1) {
            const cartIdAndGuestId = {
                cart_id: isInCart?.cartItemId,
                guestId: (0,helper_functions_getToken__WEBPACK_IMPORTED_MODULE_47__/* .getGuestId */ .P)()
            };
            cartItemRemoveMutate(cartIdAndGuestId, {
                onSuccess: handleSuccessRemoveItem,
                onError: api_manage_api_error_response_ErrorResponses__WEBPACK_IMPORTED_MODULE_20__/* .onErrorResponse */ .RJ
            });
        } else {
            const itemObject = (0,_product_details_product_details_section_helperFunction__WEBPACK_IMPORTED_MODULE_36__/* .getItemDataForAddToCart */ .JG)(isInCart, updateQuantity, (0,_product_details_product_details_section_helperFunction__WEBPACK_IMPORTED_MODULE_36__/* .getPriceAfterQuantityChange */ .bb)(isInCart, updateQuantity), (0,helper_functions_getToken__WEBPACK_IMPORTED_MODULE_47__/* .getGuestId */ .P)());
            updateMutate(itemObject, {
                onSuccess: cartUpdateHandleSuccessDecrement,
                onError: api_manage_api_error_response_ErrorResponses__WEBPACK_IMPORTED_MODULE_20__/* .onErrorResponse */ .RJ
            });
        }
    };
    const lanDirection = (0,helper_functions_getLanguage__WEBPACK_IMPORTED_MODULE_50__/* .getLanguage */ .G)() ? (0,helper_functions_getLanguage__WEBPACK_IMPORTED_MODULE_50__/* .getLanguage */ .G)() : "ltr";
    const popularCardUi = ()=>{
        return /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_13__/* .CustomStackFullWidth */ .Xw, {
            justifyContent: "center",
            alignItems: "flex-start",
            sx: {
                position: "relative",
                padding: "13px 16px 16px 13px"
            },
            children: [
                isWishlisted && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_system__WEBPACK_IMPORTED_MODULE_4__.Box, {
                    sx: {
                        color: "primary.main",
                        position: "absolute",
                        top: 20,
                        right: 10
                    },
                    children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx((_mui_icons_material_Favorite__WEBPACK_IMPORTED_MODULE_19___default()), {
                        sx: {
                            fontSize: "15px"
                        }
                    })
                }),
                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_QuickView__WEBPACK_IMPORTED_MODULE_43__/* .PrimaryToolTip */ .c, {
                    text: item?.name,
                    placement: "bottom",
                    arrow: "false",
                    children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Typography, {
                        variant: horizontalcard === "true" ? "subtitle2" : "h6",
                        marginBottom: "4px",
                        sx: {
                            lineHeight: "45px",
                            textAlign: lanDirection === "rtl" && "end",
                            color: (theme)=>theme.palette.text.custom,
                            fontSize: {
                                xs: "13px",
                                sm: "inherit"
                            },
                            overflow: "hidden",
                            textOverflow: "ellipsis",
                            display: "-webkit-box",
                            WebkitLineClamp: "2",
                            WebkitBoxOrient: "vertical",
                            height: "36px",
                            mt: "5px",
                            width: "210px",
                            [theme.breakpoints.down("sm")]: {
                                width: "146px"
                            }
                        },
                        className: "name",
                        component: "h3",
                        children: item?.name
                    })
                }),
                /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_mui_system__WEBPACK_IMPORTED_MODULE_4__.Stack, {
                    mt: "5px",
                    children: [
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Typography, {
                            fontSize: "10px",
                            component: "h4",
                            children: t("start from")
                        }),
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Typography, {
                            fontSize: {
                                xs: "14px",
                                md: "16px"
                            },
                            fontWeight: "600",
                            color: theme.palette.text.primary,
                            component: "h4",
                            children: (0,helper_functions_CardHelpers__WEBPACK_IMPORTED_MODULE_5__/* .getAmountWithSign */ .B9)(item?.price)
                        })
                    ]
                }),
                /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_13__/* .CustomStackFullWidth */ .Xw, {
                    direction: "row",
                    alignItems: "flex-start",
                    justifyContent: "space-between",
                    spacing: 2,
                    mb: "3px",
                    paddingRight: "3px",
                    children: [
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Typography, {
                            mt: "4px",
                            color: "text.secondary",
                            variant: isSmall ? "body2" : "body1",
                            children: item?.unit_type
                        }),
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_AddWithIncrementDecrement__WEBPACK_IMPORTED_MODULE_39__/* ["default"] */ .Z, {
                            onHover: state.isTransformed,
                            addToCartHandler: addToCart,
                            isProductExist: isProductExist,
                            handleIncrement: handleIncrement,
                            handleDecrement: handleDecrement,
                            count: count,
                            isLoading: isLoading,
                            updateLoading: updateLoading
                        })
                    ]
                })
            ]
        });
    };
    const listViewCardUi = ()=>{
        return /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_13__/* .CustomStackFullWidth */ .Xw, {
            justifyContent: "space-between",
            alignItems: "flex-start",
            spacing: 1,
            p: "1rem",
            children: [
                isWishlisted && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_system__WEBPACK_IMPORTED_MODULE_4__.Box, {
                    sx: {
                        color: "primary.main",
                        position: "absolute",
                        top: 20,
                        right: 10
                    },
                    children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx((_mui_icons_material_Favorite__WEBPACK_IMPORTED_MODULE_19___default()), {
                        sx: {
                            fontSize: "15px"
                        }
                    })
                }),
                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_QuickView__WEBPACK_IMPORTED_MODULE_43__/* .PrimaryToolTip */ .c, {
                    text: item?.name,
                    placement: "bottom",
                    arrow: "false",
                    children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_typographies_H3__WEBPACK_IMPORTED_MODULE_38__/* ["default"] */ .Z, {
                        text: item?.name,
                        component: "h3"
                    })
                }),
                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_13__/* .CustomBoxFullWidth */ .uu, {
                    children: item?.module_type === "pharmacy" ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Typography, {
                        className: classes.singleLineEllipsis,
                        variant: "body2",
                        color: "text.secondary",
                        sx: {
                            wordBreak: "break-word"
                        },
                        component: "h4",
                        children: item?.generic_name[0]
                    }) : /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_typographies_Body2__WEBPACK_IMPORTED_MODULE_37__/* ["default"] */ .Z, {
                        text: item?.store_name,
                        component: "h4"
                    })
                }),
                item?.unit_type ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Typography, {
                    sx: {
                        color: (theme)=>theme.palette.customColor.textGray
                    },
                    children: item?.unit_type
                }) : /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Typography, {
                    sx: {
                        color: (theme)=>theme.palette.customColor.textGray
                    },
                    children: t("No unit type")
                }),
                /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_13__/* .CustomStackFullWidth */ .Xw, {
                    direction: "row",
                    alignItems: "flex-start",
                    justifyContent: "space-between",
                    spacing: 2,
                    sx: {
                        pb: "15px"
                    },
                    children: [
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_AmountWithDiscountedAmount__WEBPACK_IMPORTED_MODULE_28__/* ["default"] */ .Z, {
                            item: item
                        }),
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_AddWithIncrementDecrement__WEBPACK_IMPORTED_MODULE_39__/* ["default"] */ .Z, {
                            onHover: state.isTransformed,
                            addToCartHandler: addToCart,
                            isProductExist: isProductExist,
                            handleIncrement: handleIncrement,
                            handleDecrement: handleDecrement,
                            count: count,
                            isLoading: isLoading,
                            updateLoading: updateLoading
                        })
                    ]
                })
            ]
        });
    };
    const foodHorizontalCardUi = ()=>{
        return /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_13__/* .CustomStackFullWidth */ .Xw, {
            justifyContent: "center",
            alignItems: "flex-start",
            sx: {
                position: "relative",
                padding: "13px 16px 16px 13px"
            },
            children: [
                isWishlisted && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_system__WEBPACK_IMPORTED_MODULE_4__.Box, {
                    sx: {
                        color: "primary.main",
                        position: "absolute",
                        top: 20,
                        right: 10
                    },
                    children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx((_mui_icons_material_Favorite__WEBPACK_IMPORTED_MODULE_19___default()), {
                        sx: {
                            fontSize: "15px"
                        }
                    })
                }),
                /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_13__/* .CustomStackFullWidth */ .Xw, {
                    direction: "row",
                    alignItems: "center",
                    justifyContent: "flex-start",
                    spacing: 0.8,
                    children: [
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_QuickView__WEBPACK_IMPORTED_MODULE_43__/* .PrimaryToolTip */ .c, {
                            text: item?.name,
                            placement: "bottom",
                            arrow: "false",
                            children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Typography, {
                                variant: horizontalcard === "true" ? "subtitle2" : "h6",
                                marginBottom: "4px",
                                sx: {
                                    color: (theme)=>theme.palette.text.custom,
                                    fontSize: {
                                        xs: "13px",
                                        sm: "inherit"
                                    },
                                    overflow: "hidden",
                                    textOverflow: "ellipsis",
                                    display: "-webkit-box",
                                    WebkitLineClamp: "2",
                                    WebkitBoxOrient: "vertical",
                                    lineHeight: "1.2",
                                    mt: "5px"
                                },
                                className: "name",
                                component: "h3",
                                children: item?.name
                            })
                        }),
                        configData?.toggle_veg_non_veg ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_SpecialCard__WEBPACK_IMPORTED_MODULE_44__/* .FoodVegNonVegFlag */ .Z5, {
                            veg: item?.veg === 0 ? "false" : "true"
                        }) : null
                    ]
                }),
                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Typography, {
                    color: "text.secondary",
                    variant: isSmall ? "body2" : "body1",
                    component: "h4",
                    children: item?.store_name
                }),
                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_13__/* .CustomStackFullWidth */ .Xw, {
                    direction: "row",
                    alignItems: "flex-start",
                    // justifyContent="space-between"
                    spacing: 13,
                    mb: "3px",
                    mt: "10px",
                    children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_AmountWithDiscountedAmount__WEBPACK_IMPORTED_MODULE_28__/* ["default"] */ .Z, {
                        item: item
                    })
                }),
                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_13__/* .CustomStackFullWidth */ .Xw, {
                    alignItems: "flex-end",
                    sx: {
                        paddingRight: "6px"
                    },
                    children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_system__WEBPACK_IMPORTED_MODULE_4__.Box, {
                        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_AddWithIncrementDecrement__WEBPACK_IMPORTED_MODULE_39__/* ["default"] */ .Z, {
                            onHover: state.isTransformed,
                            addToCartHandler: addToCart,
                            isProductExist: isProductExist,
                            handleIncrement: handleIncrement,
                            handleDecrement: handleDecrement,
                            count: count,
                            isLoading: isLoading,
                            updateLoading: updateLoading
                        })
                    })
                })
            ]
        });
    };
    const verticalCardUi = ()=>{
        return /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_13__/* .CustomStackFullWidth */ .Xw, {
            justifyContent: "center",
            alignItems: "center",
            spacing: 0.6,
            p: item?.module_type === "pharmacy" ? "5px 16px 16px 16px" : "1rem",
            children: [
                item?.module_type === "pharmacy" ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Typography, {
                    sx: {
                        overflow: "hidden",
                        textOverflow: "ellipsis",
                        display: "-webkit-box",
                        WebkitLineClamp: "1",
                        WebkitBoxOrient: "vertical",
                        width: "100%",
                        paddingTop: "3px",
                        maxWidth: "200px",
                        wordWrap: "break-word"
                    },
                    variant: "body2",
                    color: "#93A2AE",
                    textAlign: "center",
                    component: "h4",
                    children: item?.generic_name[0]
                }) : /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_typographies_Body2__WEBPACK_IMPORTED_MODULE_37__/* ["default"] */ .Z, {
                    text: item?.store_name,
                    component: "h4"
                }),
                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_QuickView__WEBPACK_IMPORTED_MODULE_43__/* .PrimaryToolTip */ .c, {
                    text: item?.name,
                    placement: "bottom",
                    arrow: "false",
                    children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Typography, {
                        className: classes.singleLineEllipsis,
                        fontSize: {
                            xs: "12px",
                            md: "14px"
                        },
                        fontWeight: "500",
                        component: "h3",
                        children: item?.name
                    })
                }),
                /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_13__/* .CustomStackFullWidth */ .Xw, {
                    justifyContent: "center",
                    alignItems: "center",
                    spacing: 0.5,
                    children: [
                        cardType === "vertical-type" ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Typography, {
                            children: item?.unit_type
                        }) : /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_CustomMultipleRatings__WEBPACK_IMPORTED_MODULE_30__/* ["default"] */ .Z, {
                            rating: 4.5,
                            withCount: true
                        }),
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_AmountWithDiscountedAmount__WEBPACK_IMPORTED_MODULE_28__/* ["default"] */ .Z, {
                            item: item
                        })
                    ]
                })
            ]
        });
    };
    const verticalCardFlashUi = ()=>{
        return /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_13__/* .CustomStackFullWidth */ .Xw, {
            justifyContent: "center",
            alignItems: "center",
            spacing: 1.5,
            // p="1rem"
            p: "0 4px",
            children: [
                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_typographies_Body2__WEBPACK_IMPORTED_MODULE_37__/* ["default"] */ .Z, {
                    text: item?.store_name
                }),
                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_QuickView__WEBPACK_IMPORTED_MODULE_43__/* .PrimaryToolTip */ .c, {
                    text: item?.name,
                    placement: "bottom",
                    arrow: "false",
                    children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_typographies_H3__WEBPACK_IMPORTED_MODULE_38__/* ["default"] */ .Z, {
                        text: item?.name,
                        component: "h3"
                    })
                }),
                /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_13__/* .CustomStackFullWidth */ .Xw, {
                    justifyContent: "center",
                    alignItems: "center",
                    spacing: 0.5,
                    children: [
                        cardType === "vertical-type" ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Typography, {
                            children: item?.unit_type
                        }) : /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_CustomMultipleRatings__WEBPACK_IMPORTED_MODULE_30__/* ["default"] */ .Z, {
                            rating: 4.5,
                            withCount: true
                        }),
                        stock === 0 ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Typography, {
                            variant: "h5",
                            display: "flex",
                            alignItems: "center",
                            flexWrap: "wrap",
                            gap: "5px",
                            sx: {
                                fontSize: {
                                    xs: "13px",
                                    sm: "18px"
                                },
                                color: (0,_mui_material__WEBPACK_IMPORTED_MODULE_2__.alpha)(theme.palette.error.deepLight, 0.7)
                            },
                            children: t("Out of Stock")
                        }) : /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_AmountWithDiscountedAmount__WEBPACK_IMPORTED_MODULE_28__/* ["default"] */ .Z, {
                            item: item
                        }),
                        /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_13__/* .CustomStackFullWidth */ .Xw, {
                            mt: "100px",
                            spacing: 1,
                            children: [
                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_linear_progressbar__WEBPACK_IMPORTED_MODULE_33__/* ["default"] */ .Z, {
                                    value: sold / stock * 100,
                                    height: 3
                                }),
                                /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_13__/* .CustomStackFullWidth */ .Xw, {
                                    direction: "row",
                                    alignItems: "center",
                                    justifyContent: "space-between",
                                    children: [
                                        /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Typography, {
                                            fontSize: "11px",
                                            fontWeight: "bold",
                                            lineHeight: "16px",
                                            variant: "body2",
                                            children: [
                                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_13__/* .CustomSpan */ .T8, {
                                                    children: t("Sold")
                                                }),
                                                " : ",
                                                sold,
                                                " ",
                                                t("items")
                                            ]
                                        }),
                                        /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Typography, {
                                            fontSize: "11px",
                                            fontWeight: "bold",
                                            lineHeight: "16px",
                                            variant: "body2",
                                            children: [
                                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_13__/* .CustomSpan */ .T8, {
                                                    children: t("Available")
                                                }),
                                                " : ",
                                                stock,
                                                " ",
                                                t("items")
                                            ]
                                        })
                                    ]
                                })
                            ]
                        })
                    ]
                })
            ]
        });
    };
    const verticalCardFlashSliderUi = ()=>{
        return /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_13__/* .CustomStackFullWidth */ .Xw, {
            justifyContent: "center",
            alignItems: "center",
            spacing: 1.5,
            p: "1rem",
            children: [
                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_typographies_Body2__WEBPACK_IMPORTED_MODULE_37__/* ["default"] */ .Z, {
                    text: item?.store_name,
                    component: "h4"
                }),
                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_QuickView__WEBPACK_IMPORTED_MODULE_43__/* .PrimaryToolTip */ .c, {
                    text: item?.name,
                    placement: "bottom",
                    arrow: "false",
                    children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_typographies_H3__WEBPACK_IMPORTED_MODULE_38__/* ["default"] */ .Z, {
                        text: item?.name,
                        component: "h3"
                    })
                }),
                /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_13__/* .CustomStackFullWidth */ .Xw, {
                    justifyContent: "center",
                    alignItems: "center",
                    spacing: 0.5,
                    children: [
                        cardType === "vertical-type" ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Typography, {
                            children: item?.unit_type
                        }) : /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_CustomMultipleRatings__WEBPACK_IMPORTED_MODULE_30__/* ["default"] */ .Z, {
                            rating: 4.5,
                            withCount: true
                        }),
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_AmountWithDiscountedAmount__WEBPACK_IMPORTED_MODULE_28__/* ["default"] */ .Z, {
                            item: item
                        })
                    ]
                })
            ]
        });
    };
    const addToWishlistHandler = (e)=>{
        e.stopPropagation();
        let token = undefined;
        if (false) {}
        if (token) {
            addFavoriteMutation(item?.id, {
                onSuccess: (response)=>{
                    if (response) {
                        reduxDispatch((0,_redux_slices_wishList__WEBPACK_IMPORTED_MODULE_27__/* .addWishList */ .TM)(item));
                        setIsWishlisted(true);
                        react_hot_toast__WEBPACK_IMPORTED_MODULE_8__["default"].success(response?.message);
                    }
                },
                onError: (error)=>{
                    react_hot_toast__WEBPACK_IMPORTED_MODULE_8__["default"].error(error.response.data.message);
                }
            });
        } else react_hot_toast__WEBPACK_IMPORTED_MODULE_8__["default"].error(t(utils_toasterMessages__WEBPACK_IMPORTED_MODULE_49__/* .not_logged_in_message */ .XO));
    };
    const removeFromWishlistHandler = (e)=>{
        e.stopPropagation();
        const onSuccessHandlerForDelete = (res)=>{
            reduxDispatch((0,_redux_slices_wishList__WEBPACK_IMPORTED_MODULE_27__/* .removeWishListItem */ .$8)(item?.id));
            setIsWishlisted(false);
            react_hot_toast__WEBPACK_IMPORTED_MODULE_8__["default"].success(res.message, {
                id: "wishlist"
            });
        };
        mutate(item?.id, {
            onSuccess: onSuccessHandlerForDelete,
            onError: (error)=>{
                react_hot_toast__WEBPACK_IMPORTED_MODULE_8__["default"].error(error.response.data.message);
            }
        });
    };
    const handleHoverOnCartIcon = (value)=>{
        dispatch({
            type: _product_details_product_details_section_states__WEBPACK_IMPORTED_MODULE_17__/* .ACTION.setIsTransformed */ .om.setIsTransformed,
            payload: value
        });
    };
    return /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_mui_system__WEBPACK_IMPORTED_MODULE_4__.Stack, {
        sx: {
            position: "relative"
        },
        children: [
            state.openModal && (0,helper_functions_getCurrentModuleType__WEBPACK_IMPORTED_MODULE_45__/* .getCurrentModuleType */ .X)() === "food" && item ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_food_details_foodDetail_modal_FoodDetailModal__WEBPACK_IMPORTED_MODULE_16__/* ["default"] */ .Z, {
                product: item,
                imageBaseUrl: imageBaseUrl,
                open: state.openModal,
                handleModalClose: handleClose,
                setOpen: (value)=>dispatch({
                        type: _product_details_product_details_section_states__WEBPACK_IMPORTED_MODULE_17__/* .ACTION.setOpenModal */ .om.setOpenModal,
                        payload: value
                    }),
                addToWishlistHandler: addToWishlistHandler,
                removeFromWishlistHandler: removeFromWishlistHandler,
                isWishlisted: isWishlisted
            }) : /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
                children: cardFor === "flashSale" ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
                    children: stock !== 0 && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_ModuleModal__WEBPACK_IMPORTED_MODULE_41__/* ["default"] */ .Z, {
                        open: state.openModal,
                        handleModalClose: handleClose,
                        configData: configData,
                        productDetailsData: item,
                        addToWishlistHandler: addToWishlistHandler,
                        removeFromWishlistHandler: removeFromWishlistHandler,
                        isWishlisted: isWishlisted
                    })
                }) : item && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_ModuleModal__WEBPACK_IMPORTED_MODULE_41__/* ["default"] */ .Z, {
                    open: state.openModal,
                    handleModalClose: handleClose,
                    configData: configData,
                    productDetailsData: item,
                    addToWishlistHandler: addToWishlistHandler,
                    removeFromWishlistHandler: removeFromWishlistHandler,
                    isWishlisted: isWishlisted
                })
            }),
            wishlistcard === "true" && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_home_stores_with_filter_cards_grid_StoresInfoCard__WEBPACK_IMPORTED_MODULE_32__/* .HeartWrapper */ .o, {
                onClick: ()=>setOpenModal(true),
                top: "5px",
                right: "5px",
                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx((_mui_icons_material_Delete__WEBPACK_IMPORTED_MODULE_1___default()), {
                    style: {
                        color: theme.palette.error.light
                    }
                })
            }),
            specialCard === "true" ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_SpecialCard__WEBPACK_IMPORTED_MODULE_44__/* ["default"] */ .ZP, {
                item: item,
                imageBaseUrl: imageBaseUrl,
                quickViewHandleClick: quickViewHandleClick,
                addToCart: addToCart,
                handleBadge: handleBadge,
                addToCartHandler: addToCart,
                isProductExist: isProductExist,
                handleIncrement: handleIncrement,
                handleDecrement: handleDecrement,
                count: count,
                handleClick: handleClick,
                isLoading: isLoading,
                updateLoading: updateLoading,
                setOpenLocationAlert: setOpenLocationAlert,
                noRecommended: noRecommended,
                configData: configData
            }) : /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(CardWrapper, {
                cardFor: cardFor,
                cardType: cardType,
                nomargin: noMargin ? "true" : "false",
                cardheight: cardheight,
                horizontalcard: horizontalcard,
                wishlistcard: wishlistcard,
                cardWidth: cardWidth,
                pharmaCommon: pharmaCommon,
                onClick: ()=>handleClick(),
                onMouseEnter: ()=>dispatch({
                        type: _product_details_product_details_section_states__WEBPACK_IMPORTED_MODULE_17__/* .ACTION.setIsTransformed */ .om.setIsTransformed,
                        payload: true
                    }),
                onMouseDown: ()=>dispatch({
                        type: _product_details_product_details_section_states__WEBPACK_IMPORTED_MODULE_17__/* .ACTION.setIsTransformed */ .om.setIsTransformed,
                        payload: true
                    }),
                onMouseLeave: ()=>dispatch({
                        type: _product_details_product_details_section_states__WEBPACK_IMPORTED_MODULE_17__/* .ACTION.setIsTransformed */ .om.setIsTransformed,
                        payload: false
                    }),
                children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_13__/* .CustomStackFullWidth */ .Xw, {
                    direction: {
                        xs: horizontalcard === "true" ? "row" : "column",
                        sm: horizontalcard === "true" ? "row" : "column"
                    },
                    justifyContent: "flex-start",
                    height: "100%",
                    sx: {
                        backgroundColor: horizontalcard === "true" && changed_bg === "true" && "primary.semiLight",
                        position: "relative"
                    },
                    children: [
                        /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(CustomCardMedia, {
                            horizontalcard: horizontalcard,
                            loveItem: loveItem,
                            children: [
                                item?.module?.module_type === "pharmacy" && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_system__WEBPACK_IMPORTED_MODULE_4__.Stack, {
                                    width: "100%",
                                    alignItems: "center",
                                    justifyContent: "center",
                                    padding: {
                                        xs: "3px 3px 8px 3px",
                                        md: "3px 3px 3px 3px"
                                    },
                                    sx: {
                                        position: "absolute",
                                        bottom: 0,
                                        backgroundColor: theme.palette.mode === "dark" ? "#B3B3B399" : "#EDEDED99",
                                        color: theme.palette.neutral[1000],
                                        fontSize: "12px",
                                        zIndex: "999"
                                    },
                                    component: "h4",
                                    children: item?.store_name
                                }),
                                handleBadge(),
                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_CustomImageContainer__WEBPACK_IMPORTED_MODULE_15__/* ["default"] */ .Z, {
                                    src: item?.image_full_url,
                                    alt: item?.title,
                                    height: "100%",
                                    width: "100%",
                                    objectfit: "cover",
                                    borderRadius: "3px"
                                }),
                                item?.module?.module_type === "food" && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_ProductsUnavailable__WEBPACK_IMPORTED_MODULE_42__/* ["default"] */ .Z, {
                                    product: item
                                }),
                                item?.halal_tag_status && item?.is_halal ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_SpecialCard__WEBPACK_IMPORTED_MODULE_44__/* .FoodHalalHaram */ .lQ, {
                                    width: 30
                                }) : "",
                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_Card_style__WEBPACK_IMPORTED_MODULE_40__/* .CustomOverLay */ .j, {
                                    hover: state.isTransformed,
                                    border_radius: "10px",
                                    children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_QuickView__WEBPACK_IMPORTED_MODULE_43__/* ["default"] */ .Z, {
                                        quickViewHandleClick: quickViewHandleClick,
                                        addToWishlistHandler: addToWishlistHandler,
                                        removeFromWishlistHandler: removeFromWishlistHandler,
                                        isWishlisted: isWishlisted,
                                        isProductExist: isProductExist,
                                        addToCartHandler: addToCart,
                                        showAddtocart: cardFor === "vertical" && !isProductExist,
                                        isLoading: isLoading,
                                        openLocationAlert: openLocationAlert,
                                        setOpenLocationAlert: setOpenLocationAlert
                                    })
                                }),
                                cardFor === "vertical" && isProductExist && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_system__WEBPACK_IMPORTED_MODULE_4__.Box, {
                                    sx: {
                                        position: "absolute",
                                        right: 10,
                                        bottom: 0,
                                        zIndex: 999
                                    },
                                    children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_AddWithIncrementDecrement__WEBPACK_IMPORTED_MODULE_39__/* ["default"] */ .Z, {
                                        verticalCard: true,
                                        onHover: state.isTransformed,
                                        addToCartHandler: addToCart,
                                        isProductExist: isProductExist,
                                        handleIncrement: handleIncrement,
                                        handleDecrement: handleDecrement,
                                        setIsHover: handleHoverOnCartIcon,
                                        count: count,
                                        updateLoading: updateLoading
                                    })
                                })
                            ]
                        }),
                        /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_13__/* .CustomStackFullWidth */ .Xw, {
                            justifyContent: "center",
                            children: [
                                cardFor === "popular items" && popularCardUi(),
                                cardFor === "vertical" && verticalCardUi(),
                                cardFor === "flashSale" && verticalCardFlashUi(),
                                cardFor === "flashSaleSlider" && verticalCardFlashSliderUi(),
                                cardFor === "food horizontal card" && foodHorizontalCardUi(),
                                cardFor === "list-view" && listViewCardUi()
                            ]
                        })
                    ]
                })
            }),
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_modal__WEBPACK_IMPORTED_MODULE_34__/* ["default"] */ .Z, {
                openModal: state.clearCartModal,
                handleClose: handleClose,
                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_product_details_product_details_section_CartClearModal__WEBPACK_IMPORTED_MODULE_35__/* ["default"] */ .Z, {
                    handleClose: handleCloseForClearCart,
                    dispatchRedux: reduxDispatch,
                    addToCard: addToCartHandler
                })
            }),
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_custom_dialog_confirm_CustomDialogConfirm__WEBPACK_IMPORTED_MODULE_29__/* ["default"] */ .Z, {
                dialogTexts: t("Are you sure you want to  delete this item?"),
                open: openModal,
                onClose: ()=>setOpenModal(false),
                onSuccess: ()=>deleteWishlistItem(item?.id)
            }),
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_modal__WEBPACK_IMPORTED_MODULE_34__/* ["default"] */ .Z, {
                openModal: openLocationAlert,
                handleClose: ()=>setOpenLocationAlert(false),
                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_GetLocationAlert__WEBPACK_IMPORTED_MODULE_31__/* ["default"] */ .Z, {
                    setOpenAlert: setOpenLocationAlert
                })
            })
        ]
    });
};
ProductCard.propTypes = {};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ProductCard);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 86838:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(580);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(65692);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _mui_system__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(97986);
/* harmony import */ var _mui_system__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_mui_system__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var react_i18next__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(57987);
/* harmony import */ var _utils_CustomFunctions__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(81261);
/* harmony import */ var _helper_functions_getItemsOrFoods__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(83838);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([react_i18next__WEBPACK_IMPORTED_MODULE_5__, _utils_CustomFunctions__WEBPACK_IMPORTED_MODULE_6__, _helper_functions_getItemsOrFoods__WEBPACK_IMPORTED_MODULE_7__]);
([react_i18next__WEBPACK_IMPORTED_MODULE_5__, _utils_CustomFunctions__WEBPACK_IMPORTED_MODULE_6__, _helper_functions_getItemsOrFoods__WEBPACK_IMPORTED_MODULE_7__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);








const OverLay = ({ isScheduled , theme , t , thisText , endText , endText1  })=>/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_system__WEBPACK_IMPORTED_MODULE_4__.Stack, {
        sx: {
            position: "absolute",
            bottom: 0,
            left: 0,
            width: "100%",
            background: (theme)=>theme.palette.primary.overLay,
            opacity: "0.5",
            // color: (theme) => theme.palette.neutral[100],
            padding: "6px",
            alignItems: "center",
            justifyContent: "center"
        },
        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_3__.Typography, {
            align: "center",
            color: theme.palette.whiteContainer.main,
            children: isScheduled ? t(`${thisText} ${(0,_helper_functions_getItemsOrFoods__WEBPACK_IMPORTED_MODULE_7__/* .getItemsOrFoods */ .p)().replace("s", "")} ${endText}`) : t(`${thisText} ${(0,_helper_functions_getItemsOrFoods__WEBPACK_IMPORTED_MODULE_7__/* .getItemsOrFoods */ .p)().replace("s", "")} ${endText1}`)
        })
    });
const ProductsUnavailable = (props)=>{
    const { borderRadius , product  } = props;
    const theme = (0,_mui_material__WEBPACK_IMPORTED_MODULE_3__.useTheme)();
    const { t  } = (0,react_i18next__WEBPACK_IMPORTED_MODULE_5__.useTranslation)();
    const thisText = t("This");
    const endText = t("is not available right now. You can order it later.");
    const endText1 = t("is not available right now.");
    return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        children: !(0,_utils_CustomFunctions__WEBPACK_IMPORTED_MODULE_6__/* .isAvailable */ ._e)(product.available_time_starts, product.available_time_ends) && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(OverLay, {
            thisText: thisText,
            endText: endText,
            endText1: endText1,
            isScheduled: product?.schedule_order,
            theme: theme,
            t: t
        })
    });
};
ProductsUnavailable.propTypes = {};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ProductsUnavailable);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 12574:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(580);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _mui_material_LinearProgress__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(25545);
/* harmony import */ var _mui_material_LinearProgress__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_mui_material_LinearProgress__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _mui_material_styles__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(18442);
/* harmony import */ var _mui_material_styles__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_mui_material_styles__WEBPACK_IMPORTED_MODULE_4__);





const BorderLinearProgress = (0,_mui_material_styles__WEBPACK_IMPORTED_MODULE_4__.styled)((_mui_material_LinearProgress__WEBPACK_IMPORTED_MODULE_3___default()))(({ theme , height  })=>({
        height: height ? height : 8,
        borderRadius: 5
    }));
const CustomLinearProgressbar = ({ value , height  })=>{
    return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(BorderLinearProgress, {
        variant: "determinate",
        value: value,
        height: height
    });
};
CustomLinearProgressbar.propTypes = {};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (CustomLinearProgressbar);


/***/ }),

/***/ 40409:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(65692);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_i18next__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(57987);
/* harmony import */ var styled_components_TextWithEllipsis__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(53556);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([react_i18next__WEBPACK_IMPORTED_MODULE_2__]);
react_i18next__WEBPACK_IMPORTED_MODULE_2__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];




const H3 = (props)=>{
    const { text , ...rest } = props;
    const { t  } = (0,react_i18next__WEBPACK_IMPORTED_MODULE_2__.useTranslation)();
    const classes = (0,styled_components_TextWithEllipsis__WEBPACK_IMPORTED_MODULE_3__/* .textWithEllipsis */ .C)();
    return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_1__.Typography, {
        variant: "subtitle1",
        sx: {
            overflow: "hidden",
            textOverflow: "ellipsis",
            display: "-webkit-box",
            WebkitLineClamp: "1",
            WebkitBoxOrient: "vertical"
        },
        // className={classes.singleLineEllipsis}
        maxHeight: "20px",
        ...rest,
        children: t(text)
    });
};
H3.propTypes = {};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (H3);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;