"use strict";
exports.id = 949;
exports.ids = [949];
exports.modules = {

/***/ 30949:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "TestimonialSlideImage": () => (/* binding */ TestimonialSlideImage),
/* harmony export */   "TestimonialSlideText": () => (/* binding */ TestimonialSlideText),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(65692);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_mui_material__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _mui_system__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(97986);
/* harmony import */ var _mui_system__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_mui_system__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react_slick__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(38096);
/* harmony import */ var react_slick__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_slick__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var slick_carousel_slick_slick_theme_css__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(61598);
/* harmony import */ var slick_carousel_slick_slick_theme_css__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(slick_carousel_slick_slick_theme_css__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var slick_carousel_slick_slick_css__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(88278);
/* harmony import */ var slick_carousel_slick_slick_css__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(slick_carousel_slick_slick_css__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(45269);
/* harmony import */ var _CustomImageContainer__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(58861);
/* harmony import */ var components_rtl__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(66673);
/* harmony import */ var helper_functions_getLanguage__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(46573);
/* harmony import */ var _container__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(28332);
/* harmony import */ var _DollarSignHighlighter__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(40116);
/* harmony import */ var _icons_NextIcon__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(80893);
/* harmony import */ var _icons_PrevIcon__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(11132);
/* eslint-disable @next/next/no-img-element */ 















const PrevWrapper = (0,_mui_material__WEBPACK_IMPORTED_MODULE_2__.styled)(_mui_system__WEBPACK_IMPORTED_MODULE_3__.Box)(({ theme  })=>({
        zIndex: 1,
        [theme.breakpoints.down("lg")]: {
            left: -5
        },
        [theme.breakpoints.down("sm")]: {
            left: -10,
            display: "none"
        }
    }));
const NextWrapper = (0,_mui_material__WEBPACK_IMPORTED_MODULE_2__.styled)(_mui_system__WEBPACK_IMPORTED_MODULE_3__.Box)(({ theme  })=>({
        zIndex: 1,
        [theme.breakpoints.down("lg")]: {
            right: -5
        },
        [theme.breakpoints.down("sm")]: {
            right: -5,
            display: "none"
        }
    }));
const Next = ({ onClick , className  })=>{
    return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(NextWrapper, {
        className: `client-nav client-next ${className}`,
        onClick: onClick,
        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_icons_NextIcon__WEBPACK_IMPORTED_MODULE_12__/* ["default"] */ .Z, {})
    });
};
const Prev = ({ onClick , className  })=>{
    return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(PrevWrapper, {
        className: `client-nav client-prev ${className}`,
        onClick: onClick,
        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_icons_PrevIcon__WEBPACK_IMPORTED_MODULE_13__/* ["default"] */ .Z, {})
    });
};
const Testimonials = ({ isSmall , landingPageData  })=>{
    const theme = (0,_mui_material__WEBPACK_IMPORTED_MODULE_2__.useTheme)();
    const [testimonials, setTestimonials] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)([]);
    const lanDirection = (0,helper_functions_getLanguage__WEBPACK_IMPORTED_MODULE_14__/* .getLanguage */ .G)() ? (0,helper_functions_getLanguage__WEBPACK_IMPORTED_MODULE_14__/* .getLanguage */ .G)() : "ltr";
    (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(()=>{
        // Filter the testimonial_list based on the status property
        const filteredTestimonials = landingPageData?.testimonial_list?.filter((item)=>item?.status === 1);
        // Set the filtered testimonials in the state
        setTestimonials(filteredTestimonials);
    }, [
        landingPageData
    ]);
    const [nav1, setNav1] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(null);
    const [nav2, setNav2] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(null);
    const [indexState, setIndexState] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)({
        oldSlide: 0,
        activeSlide: 0,
        activeSlide2: 0
    });
    const setting = {
        autoplay: true,
        dots: false,
        arrow: true,
        infinite: testimonials.length > 1 ? true : false,
        slidesToShow: testimonials.length > 4 ? 3 : 1,
        focusOnSelect: true,
        className: "center",
        centerMode: true,
        centerPadding: "200px",
        speed: testimonials.length > 4 ? 1000 : 2000,
        autoplaySpeed: 4000,
        beforeChange: (current, next)=>setIndexState({
                oldSlide: current,
                activeSlide: next
            }),
        afterChange: (current)=>setIndexState({
                activeSlide2: current
            }),
        prevArrow: testimonials.length > 1 && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(Prev, {}),
        nextArrow: testimonials.length > 1 && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(Next, {}),
        responsive: [
            {
                breakpoint: 1023,
                settings: {
                    slidesToShow: testimonials.length > 3 ? 3 : 1,
                    centerPadding: "64px"
                }
            },
            {
                breakpoint: 767,
                settings: {
                    slidesToShow: testimonials.length > 3 ? 3 : 1,
                    centerPadding: "0"
                }
            },
            {
                breakpoint: 600,
                settings: {
                    slidesToShow: testimonials.length > 3 ? 3 : 1,
                    initialSlide: 2,
                    centerPadding: "0"
                }
            }
        ]
    };
    const textSliderSettings = {
        fade: true
    };
    if (!testimonials?.length) {
        return;
    }
    return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(components_rtl__WEBPACK_IMPORTED_MODULE_9__/* .RTL */ .l, {
        direction: lanDirection,
        children: landingPageData && testimonials?.length > 0 && /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_container__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .Z, {
            children: [
                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_7__/* .CustomStackFullWidth */ .Xw, {
                    py: {
                        xs: "30px",
                        md: "3.35rem"
                    },
                    spacing: 4,
                    children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Typography, {
                        textAlign: "center",
                        variant: isSmall ? "h7" : "h4",
                        fontSize: {
                            xs: "17px",
                            sm: "24px",
                            md: "30px"
                        },
                        fontWeight: 500,
                        sx: {
                            opacity: ".9"
                        },
                        component: "h2",
                        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_DollarSignHighlighter__WEBPACK_IMPORTED_MODULE_11__/* ["default"] */ .Z, {
                            theme: theme,
                            text: landingPageData?.testimonial_title
                        })
                    })
                }),
                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_styled_components_CustomStyles_style__WEBPACK_IMPORTED_MODULE_7__/* .CustomStackFullWidth */ .Xw, {
                    pb: {
                        xs: "0px",
                        md: "45px"
                    },
                    sx: {
                        marginTop: "5px",
                        textAlign: "center"
                    },
                    children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_system__WEBPACK_IMPORTED_MODULE_3__.Box, {
                        sx: {
                            display: "block",
                            position: "relative"
                        },
                        className: "testimonials-slider",
                        children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_mui_system__WEBPACK_IMPORTED_MODULE_3__.Box, {
                            sx: {
                                gap: "35px"
                            },
                            children: [
                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_system__WEBPACK_IMPORTED_MODULE_3__.Box, {
                                    className: "slider-wrapper",
                                    children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx((react_slick__WEBPACK_IMPORTED_MODULE_4___default()), {
                                        asNavFor: nav2,
                                        ref: (e)=>setNav1(e),
                                        ...setting,
                                        rtl: landingPageData?.direction === "rtl",
                                        children: testimonials?.map((item, i)=>/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
                                                children: item?.status === 1 && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(TestimonialSlideImage, {
                                                    img: item?.reviewer_image_full_url,
                                                    indexState: indexState,
                                                    currentIndex: i,
                                                    lanDirection: lanDirection
                                                }, i)
                                            }))
                                    })
                                }),
                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx((react_slick__WEBPACK_IMPORTED_MODULE_4___default()), {
                                    asNavFor: nav1,
                                    ref: (e)=>setNav2(e),
                                    ...textSliderSettings,
                                    rtl: landingPageData?.direction === "rtl",
                                    children: testimonials.map((item, i)=>/*#__PURE__*/ (0,react__WEBPACK_IMPORTED_MODULE_1__.createElement)(TestimonialSlideText, {
                                            ...item,
                                            key: i,
                                            lanDirection: lanDirection
                                        }))
                                })
                            ]
                        })
                    })
                })
            ]
        })
    });
};
const TestimonialSlideImage = (props)=>{
    const { img , indexState , currentIndex , lanDirection  } = props;
    const theme = (0,_mui_material__WEBPACK_IMPORTED_MODULE_2__.useTheme)();
    const primary = theme.palette.primary.main;
    return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_system__WEBPACK_IMPORTED_MODULE_3__.Stack, {
            p: "4px",
            sx: {
                position: "relative",
                width: "100%",
                maxWidth: "140px",
                aspectRatio: "1",
                margin: "2px auto",
                direction: lanDirection
            },
            children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_system__WEBPACK_IMPORTED_MODULE_3__.Box, {
                sx: {
                    position: "absolute",
                    inset: "0",
                    background: currentIndex === indexState?.activeSlide2 && primary,
                    width: "100%",
                    height: "100%",
                    aspectRatio: "1",
                    borderRadius: "50%",
                    overflow: "hidden",
                    padding: "5px",
                    transition: "background-color ease-in-out 0.3s",
                    transform: `scale(${currentIndex === indexState?.activeSlide2 ? 1.01 : 1})`
                },
                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_CustomImageContainer__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .Z, {
                    src: img,
                    alt: "",
                    width: "100%",
                    objectFit: "cover",
                    borderRadius: "50%"
                })
            })
        })
    });
};
const TestimonialSlideText = (props)=>{
    const theme = (0,_mui_material__WEBPACK_IMPORTED_MODULE_2__.useTheme)();
    const { name , designation , review , activeState , index , lanDirection  } = props;
    const isSmall = (0,_mui_material__WEBPACK_IMPORTED_MODULE_2__.useMediaQuery)(theme.breakpoints.down("sm"));
    return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_system__WEBPACK_IMPORTED_MODULE_3__.Box, {
        className: `slide-item ${index > activeState ? "next-slide" : index == activeState ? "active" : "prev-slide"}`,
        sx: {
            marginTop: "30px"
        },
        children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_mui_system__WEBPACK_IMPORTED_MODULE_3__.Stack, {
            className: "content",
            spacing: 3,
            alignItems: "center",
            sx: {
                direction: lanDirection
            },
            children: [
                review && /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Typography, {
                    fontSize: {
                        xs: "12px",
                        md: "18px"
                    },
                    fontWeight: "400",
                    color: theme.palette.primary.main,
                    lineHeight: "2",
                    fontStyle: "italic",
                    sx: {
                        maxWidth: {
                            xs: "280px",
                            sm: "400px",
                            md: "580px"
                        }
                    },
                    children: [
                        "“",
                        review,
                        "”"
                    ]
                }),
                /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_mui_system__WEBPACK_IMPORTED_MODULE_3__.Stack, {
                    spacing: 1,
                    children: [
                        name && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Typography, {
                            variant: isSmall ? "subtitle2" : "h6",
                            fontWeight: "600",
                            component: "h3",
                            children: name
                        }),
                        designation && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_mui_material__WEBPACK_IMPORTED_MODULE_2__.Typography, {
                            variant: isSmall ? "body2" : "body1",
                            fontSize: {
                                xs: "12px",
                                sm: "14px",
                                md: "16px"
                            },
                            fontWeight: 400,
                            className: "designation",
                            color: "text.secondary",
                            children: designation
                        })
                    ]
                })
            ]
        })
    });
};
Testimonials.propTypes = {};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Testimonials);


/***/ }),

/***/ 66673:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "l": () => (/* binding */ RTL)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(580);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _emotion_cache__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(71913);
/* harmony import */ var _emotion_cache__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_emotion_cache__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _emotion_react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(72805);
/* harmony import */ var _emotion_react__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_emotion_react__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var stylis_plugin_rtl__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(93195);
/* harmony import */ var stylis_plugin_rtl__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(stylis_plugin_rtl__WEBPACK_IMPORTED_MODULE_5__);






const styleCache = ()=>_emotion_cache__WEBPACK_IMPORTED_MODULE_3___default()({
        key: "rtl",
        prepend: true,
        stylisPlugins: [
            (stylis_plugin_rtl__WEBPACK_IMPORTED_MODULE_5___default())
        ]
    });
const RTL = (props)=>{
    const { children , direction  } = props;
    (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(()=>{
        document.dir = direction;
    }, [
        direction
    ]);
    if (direction === "rtl") {
        return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_emotion_react__WEBPACK_IMPORTED_MODULE_4__.CacheProvider, {
            value: styleCache(),
            children: children
        });
    }
    return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        children: children
    });
};
RTL.propTypes = {
    children: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().node.isRequired),
    direction: prop_types__WEBPACK_IMPORTED_MODULE_2___default().oneOf([
        "ltr",
        "rtl"
    ])
};


/***/ })

};
;